/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.HtLexReader;
import jp.hishidama.html.lexer.rule.AttrRule;
import jp.hishidama.html.lexer.rule.CDataRule;
import jp.hishidama.html.lexer.rule.CommentRule;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.rule.MarkDeclRule;
import jp.hishidama.html.lexer.rule.MarkupRule;
import jp.hishidama.html.lexer.rule.NameRule;
import jp.hishidama.html.lexer.rule.ScriptRule;
import jp.hishidama.html.lexer.rule.SeparateRule;
import jp.hishidama.html.lexer.rule.TagRule;
import jp.hishidama.html.lexer.rule.TextRule;
import jp.hishidama.html.lexer.rule.ValueRule;
import jp.hishidama.html.lexer.rule.XmlDeclRule;
import jp.hishidama.html.lexer.token.ListToken;
import jp.hishidama.html.lexer.token.Markup;
import jp.hishidama.html.lexer.token.ScriptToken;
import jp.hishidama.html.lexer.token.SkipToken;
import jp.hishidama.html.lexer.token.Tag;
import jp.hishidama.html.lexer.token.TextToken;
import jp.hishidama.html.lexer.token.Token;
import jp.hishidama.html.lexer.token.ValueToken;

public class HtLexer
implements Closeable {
    private HtLexReader hr;
    protected ListToken list;
    protected SeparateRule TAG_OPEN_RULE = this.createTagOpenRule();
    private ValueRule attrValueRule;
    private TextRule skipRule;
    private TextRule textRule;
    private TextRule topTextRule;
    private MarkupRule markupRlue;
    private TagRule tagRule;
    private MarkDeclRule declareRule;
    private CommentRule commentRule;
    private XmlDeclRule xmlDeclRule;
    protected CDataRule cdataRule;
    protected ScriptRule scriptRule;

    public static ListToken parse(String s) {
        try {
            return HtLexer.parse(new StringReader(s));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ListToken parse(Reader r) throws IOException {
        HtLexer lexer = new HtLexer(r);
        try {
            ListToken listToken = lexer.parse();
            return listToken;
        }
        finally {
            try {
                lexer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public HtLexer() {
    }

    public HtLexer(Reader r) {
        this.setTarget(r);
    }

    public HtLexer(String s) {
        this.setTarget(s);
    }

    public void setTarget(Reader r) {
        this.hr = new HtLexReader(r);
        this.list = new ListToken();
    }

    public void setTarget(String s) {
        if (s == null) {
            s = "";
        }
        this.setTarget(new StringReader(s));
    }

    protected void add(Token token) {
        this.list.add(token);
    }

    protected SeparateRule createTagOpenRule() {
        return new TagOpenRule();
    }

    public ListToken parse() throws IOException {
        TextRule textRule = this.getTopTextRule();
        MarkupRule markupRule = this.getMarkupRule();
        while (true) {
            Markup mark;
            SkipToken skip;
            if ((skip = textRule.skipSpace()) != null) {
                this.add(skip);
            }
            if ((mark = markupRule.parse()) != null) {
                Tag tag;
                this.add(mark);
                if (!(mark instanceof Tag) || !"script".equalsIgnoreCase((tag = (Tag)mark).getName()) || !tag.isStart() || tag.isEnd()) continue;
                this.parseScript();
                continue;
            }
            TextToken text = textRule.parse();
            if (text == null) break;
            this.add(text);
        }
        return this.list;
    }

    protected void parseScript() throws IOException {
        block2: {
            MarkupRule markupRule = this.getMarkupRule();
            ScriptRule scriptRule = this.getScriptRule();
            while (true) {
                Tag tag;
                ScriptToken text;
                if ((text = scriptRule.parse()) != null) {
                    this.add(text);
                    continue;
                }
                Markup mark = markupRule.parse();
                if (mark == null) break block2;
                this.add(mark);
                if (mark instanceof Tag && "script".equalsIgnoreCase((tag = (Tag)mark).getName()) && tag.isEnd()) break;
            }
            return;
        }
    }

    public ValueToken parseAttrValue(String quote1, String quote2) throws IOException {
        if (this.attrValueRule == null) {
            this.attrValueRule = new ValueRule(this);
        }
        return this.attrValueRule.parseAll(quote1, quote2);
    }

    public SkipToken parseSkip() throws IOException {
        if (this.skipRule == null) {
            this.skipRule = new TextRule(this);
        }
        SkipToken s = this.skipRule.skipSpace();
        Char c = this.readChar();
        if (c == Char.EOF) {
            return s;
        }
        this.unreadChar(c);
        throw new IOException("not skip char: " + c);
    }

    public TextToken parseText() throws IOException {
        if (this.textRule == null) {
            this.textRule = new TextRule(this);
            this.textRule.setSepRule(new EndlessRule());
        }
        return this.textRule.parse();
    }

    protected Char readChar() throws IOException {
        return this.hr.readChar();
    }

    protected void unreadChar(Char ch) {
        this.hr.unreadChar(ch);
    }

    @Override
    public void close() throws IOException {
        this.hr.close();
    }

    protected final TextRule getTopTextRule() {
        if (this.topTextRule == null) {
            this.topTextRule = this.createTopTextRule();
        }
        return this.topTextRule;
    }

    protected TextRule createTopTextRule() {
        TextRule rule = new TextRule(this);
        rule.setSepRule(this.TAG_OPEN_RULE);
        return rule;
    }

    protected TextRule createTextRule() {
        return new TextRule(this);
    }

    protected final MarkupRule getMarkupRule() {
        if (this.markupRlue == null) {
            this.markupRlue = this.createMarkupRule();
        }
        return this.markupRlue;
    }

    protected MarkupRule createMarkupRule() {
        return new MarkupRule(this);
    }

    protected final TagRule getTagRule() {
        if (this.tagRule == null) {
            this.tagRule = this.createTagRule();
        }
        return this.tagRule;
    }

    protected TagRule createTagRule() {
        TagRule rule = new TagRule(this);
        AttrRule attrRule = new AttrRule(this);
        rule.setAttrRule(attrRule);
        attrRule.setNameRule(new NameRule(this));
        attrRule.setValueRule(new ValueRule(this));
        return rule;
    }

    protected final MarkDeclRule getDeclareRule() {
        if (this.declareRule == null) {
            this.declareRule = this.createDeclareRule();
        }
        return this.declareRule;
    }

    protected MarkDeclRule createDeclareRule() {
        MarkDeclRule rule = new MarkDeclRule(this);
        rule.setValueRule(new ValueRule(this));
        return rule;
    }

    protected final CommentRule getCommentRule() {
        if (this.commentRule == null) {
            this.commentRule = this.createCommentRule();
        }
        return this.commentRule;
    }

    protected CommentRule createCommentRule() {
        CommentRule rule = new CommentRule(this);
        rule.setTextRule(new TextRule(this));
        return rule;
    }

    protected final XmlDeclRule getXmlDeclRule() {
        if (this.xmlDeclRule == null) {
            this.xmlDeclRule = this.createXmlDeclRule();
        }
        return this.xmlDeclRule;
    }

    protected XmlDeclRule createXmlDeclRule() {
        XmlDeclRule rule = new XmlDeclRule(this);
        AttrRule attrRule = new AttrRule(this);
        rule.setAttrRule(attrRule);
        attrRule.setNameRule(new NameRule(this));
        attrRule.setValueRule(new ValueRule(this));
        return rule;
    }

    protected final CDataRule getCDataRule() {
        if (this.cdataRule == null) {
            this.cdataRule = this.createCDataRule();
        }
        return this.cdataRule;
    }

    protected CDataRule createCDataRule() {
        CDataRule rule = new CDataRule(this);
        rule.setTextRule(new TextRule(this));
        return rule;
    }

    protected final ScriptRule getScriptRule() {
        if (this.scriptRule == null) {
            this.scriptRule = this.createScriptRule();
        }
        return this.scriptRule;
    }

    protected ScriptRule createScriptRule() {
        return new ScriptRule(this);
    }

    protected class EndlessRule
    implements SeparateRule {
        protected EndlessRule() {
        }

        @Override
        public boolean isEnd(Char ch) throws IOException {
            return false;
        }
    }

    protected class TagOpenRule
    implements SeparateRule {
        protected TagOpenRule() {
        }

        @Override
        public boolean isEnd(Char ch) throws IOException {
            MarkupRule markupRule;
            MarkupRule markupRule2 = markupRule = HtLexer.this.getMarkupRule();
            markupRule2.getClass();
            HtLexerRule.Chars cs = new HtLexerRule.Chars(markupRule2, ch);
            boolean r = markupRule.getMarkupRule(cs) != null;
            cs.clear(1);
            return r;
        }
    }
}

