/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.rule.MarkupRule;
import jp.hishidama.html.lexer.rule.SeparateRule;
import jp.hishidama.html.lexer.rule.TextRule;
import jp.hishidama.html.lexer.token.Comment;
import jp.hishidama.html.lexer.token.TextToken;

public class CommentRule
extends MarkupRule {
    protected TextRule textRule;
    protected final SeparateRule CMT_SEP_RULE = this.createSepRule();
    private static final CharType[] START_TYPE = new CharType[]{CharType.TAGO, CharType.EXCL, CharType.HYPHEN, CharType.HYPHEN};

    protected CommentRule(HtLexer data) {
        super(data);
    }

    protected void setTextRule(TextRule rule) {
        this.textRule = rule;
        this.textRule.setSepRule(this.CMT_SEP_RULE);
    }

    protected SeparateRule createSepRule() {
        return new CommentSepRule();
    }

    public boolean isStart(HtLexerRule.Chars cs) throws IOException {
        return cs.isType(START_TYPE);
    }

    @Override
    @Deprecated
    public Comment parse() throws IOException {
        return (Comment)super.parse();
    }

    @Override
    protected Comment parse(HtLexerRule.Chars cs) throws IOException {
        StringBuilder tago = cs.clear(START_TYPE.length);
        Comment tag = this.createCommentToken();
        tag.setTag1(tago);
        this.parseText(tag);
        this.parseTagC(tag);
        return tag;
    }

    protected Comment createCommentToken() {
        return new Comment();
    }

    protected void parseText(Comment tag) throws IOException {
        TextToken text = this.textRule.parse();
        tag.setComment(text);
    }

    protected class CommentSepRule
    implements SeparateRule {
        protected CommentSepRule() {
        }

        @Override
        public boolean isEnd(Char ch) throws IOException {
            if (ch.getType() == CharType.HYPHEN) {
                Char n = CommentRule.this.data.readChar();
                try {
                    if (n.getType() == CharType.HYPHEN) {
                        Char n2 = CommentRule.this.data.readChar();
                        CommentRule.this.data.unreadChar(n2);
                        if (n2.getType() == CharType.TAGC) {
                            return true;
                        }
                    }
                }
                finally {
                    CommentRule.this.data.unreadChar(n);
                }
            }
            return false;
        }
    }
}

