/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.rule.MarkupRule;
import jp.hishidama.html.lexer.rule.SeparateRule;
import jp.hishidama.html.lexer.rule.TextRule;
import jp.hishidama.html.lexer.token.CData;
import jp.hishidama.html.lexer.token.NameAtom;
import jp.hishidama.html.lexer.token.NamedMarkup;
import jp.hishidama.html.lexer.token.TextToken;
import jp.hishidama.html.lexer.token.WordAtom;

public class CDataRule
extends MarkupRule {
    protected TextRule textRule;
    protected final SeparateRule CDATA_SEP_RULE = this.createCDataSepRule();
    protected static final CharType[] START_TYPE = new CharType[]{CharType.TAGO, CharType.EXCL, CharType.BRAO, CharType.STRING, CharType.BRAO};

    protected CDataRule(HtLexer data) {
        super(data);
    }

    public void setTextRule(TextRule rule) {
        this.textRule = rule;
        this.textRule.setSepRule(this.CDATA_SEP_RULE);
    }

    protected SeparateRule createCDataSepRule() {
        return new CDataSepRule();
    }

    public boolean isStart(HtLexerRule.Chars cs) throws IOException {
        return cs.isType(START_TYPE);
    }

    @Override
    @Deprecated
    public CData parse() throws IOException {
        return (CData)super.parse();
    }

    @Override
    protected CData parse(HtLexerRule.Chars cs) throws IOException {
        StringBuilder tago = cs.clear(3);
        CData tag = this.createCDataToken();
        tag.setTag1(tago);
        this.parseName(tag);
        this.parseBraO(tag);
        this.parseText(tag);
        this.parseTagC(tag);
        return tag;
    }

    protected CData createCDataToken() {
        return new CData();
    }

    @Override
    protected void parseName(NamedMarkup tag) throws IOException {
        StringBuilder sb = new StringBuilder();
        Char ch = this.data.readChar();
        block3: while (ch != Char.EOF) {
            switch (ch.getType()) {
                case SPACE: 
                case EOL: 
                case BRAO: {
                    this.data.unreadChar(ch);
                    break block3;
                }
                default: {
                    sb.append((CharSequence)ch.getSB());
                    ch = this.data.readChar();
                }
            }
        }
        NameAtom name = this.createNameAtom();
        name.setName(sb);
        tag.setName(name);
    }

    protected void parseBraO(CData tag) throws IOException {
        StringBuilder sb = new StringBuilder();
        Char ch = this.data.readChar();
        while (ch != Char.EOF) {
            sb.append((CharSequence)ch.getSB());
            if (ch.getType() == CharType.BRAO) break;
            ch = this.data.readChar();
        }
        WordAtom word = this.createWordAtom();
        word.setString(sb);
        tag.setBraO(word);
    }

    protected WordAtom createWordAtom() {
        return new WordAtom();
    }

    protected void parseText(CData tag) throws IOException {
        TextToken text = this.textRule.parse();
        tag.setData(text);
    }

    protected class CDataSepRule
    implements SeparateRule {
        protected CDataSepRule() {
        }

        @Override
        public boolean isEnd(Char ch) throws IOException {
            if (ch.getType() == CharType.BRAC) {
                Char n = CDataRule.this.data.readChar();
                try {
                    if (n.getType() == CharType.BRAC) {
                        Char n2 = CDataRule.this.data.readChar();
                        CDataRule.this.data.unreadChar(n2);
                        if (n2.getType() == CharType.TAGC) {
                            return true;
                        }
                    }
                }
                finally {
                    CDataRule.this.data.unreadChar(n);
                }
            }
            return false;
        }
    }
}

