/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.rule;

import java.io.IOException;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.rule.HtLexerRule;
import jp.hishidama.html.lexer.rule.NameRule;
import jp.hishidama.html.lexer.rule.SeparateRule;
import jp.hishidama.html.lexer.rule.ValueRule;
import jp.hishidama.html.lexer.token.AttributeToken;
import jp.hishidama.html.lexer.token.NameAtom;
import jp.hishidama.html.lexer.token.ValueToken;
import jp.hishidama.html.lexer.token.WordAtom;

public class AttrRule
extends HtLexerRule {
    protected NameRule nameRule;
    protected ValueRule valueRule;

    protected AttrRule(HtLexer data) {
        super(data);
    }

    protected void setNameRule(NameRule rule) {
        this.nameRule = rule;
        this.nameRule.setSepRule(this.createNameSepRule());
    }

    protected void setValueRule(ValueRule rule) {
        this.valueRule = rule;
        this.valueRule.setSepRule(this.createValueSepRule());
    }

    protected SeparateRule createNameSepRule() {
        return new NameSepRule(this.sepRule);
    }

    protected SeparateRule createValueSepRule() {
        return new ValueSepRule(this.sepRule);
    }

    @Override
    public AttributeToken parse() throws IOException {
        NameAtom name = this.nameRule.parse();
        if (name == null) {
            return null;
        }
        AttributeToken attr = this.createAttrToken();
        attr.setName(name);
        attr.setSkip1(this.skipSpace());
        Char ch = this.data.readChar();
        if (ch.getType() == CharType.EQ) {
            WordAtom eq = new WordAtom();
            eq.setString(ch.getSB());
            attr.setLet(eq);
            attr.setSkip2(this.skipSpace());
            ValueToken value = this.valueRule.parse();
            attr.setValue(value);
        } else {
            this.data.unreadChar(ch);
        }
        return attr;
    }

    protected AttributeToken createAttrToken() {
        return new AttributeToken();
    }

    protected class NameSepRule
    extends ValueSepRule {
        protected NameSepRule(SeparateRule sep) {
            super(sep);
        }

        @Override
        public boolean isEnd(Char ch) throws IOException {
            if (super.isEnd(ch)) {
                return true;
            }
            return ch.getType() == CharType.EQ;
        }
    }

    protected class ValueSepRule
    implements SeparateRule {
        protected SeparateRule sepRule;

        protected ValueSepRule(SeparateRule sep) {
            this.sepRule = sep;
        }

        @Override
        public boolean isEnd(Char ch) throws IOException {
            if (this.sepRule.isEnd(ch)) {
                return true;
            }
            switch (ch.getType()) {
                case SPACE: 
                case EOL: {
                    return true;
                }
            }
            return false;
        }
    }
}

