/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html.lexer.reader;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import jp.hishidama.html.lexer.reader.Char;
import jp.hishidama.html.lexer.reader.CharType;

public class HtLexReader
extends PushbackReader {
    private Deque<Char> tbuf = new ArrayDeque<Char>();

    public HtLexReader(Reader r) {
        super(r, 2);
    }

    public Char readChar() throws IOException {
        Char t = this.tbuf.pollLast();
        if (t == null) {
            t = this.readChar0();
        }
        return t;
    }

    public void unreadChar(Char ch) {
        if (ch != null && ch != Char.EOF) {
            this.tbuf.addLast(ch);
        }
    }

    protected Char readChar0() throws IOException {
        int n = this.read();
        if (n < 0) {
            return Char.EOF;
        }
        char c = (char)n;
        switch (c) {
            case '\t': 
            case ' ': {
                return this.readCharSpace(c);
            }
            case '\r': {
                return this.readCharCR(c);
            }
            case '\n': {
                return this.readCharLF(c);
            }
            case '<': {
                return Char.createChar(CharType.TAGO, c);
            }
            case '>': {
                return Char.createChar(CharType.TAGC, c);
            }
            case '/': {
                return Char.createChar(CharType.SLASH, c);
            }
            case '!': {
                return Char.createChar(CharType.EXCL, c);
            }
            case '?': {
                return Char.createChar(CharType.QUES, c);
            }
            case '[': {
                return Char.createChar(CharType.BRAO, c);
            }
            case ']': {
                return Char.createChar(CharType.BRAC, c);
            }
            case '=': {
                return Char.createChar(CharType.EQ, c);
            }
            case '\'': {
                return Char.createChar(CharType.SQ, c);
            }
            case '\"': {
                return Char.createChar(CharType.DQ, c);
            }
            case '\\': {
                return Char.createChar(CharType.ESC, c);
            }
            case '-': {
                return Char.createChar(CharType.HYPHEN, c);
            }
        }
        return this.readCharString(c);
    }

    protected Char readCharSpace(char c) throws IOException {
        StringBuilder sb;
        block4: {
            int n;
            sb = new StringBuilder();
            block3: while (true) {
                sb.append(c);
                n = this.read();
                if (n < 0) break block4;
                c = (char)n;
                switch (c) {
                    case '\t': 
                    case ' ': {
                        continue block3;
                    }
                }
                break;
            }
            this.unread(n);
        }
        return Char.createChar(CharType.SPACE, sb);
    }

    protected Char readCharCR(char c) throws IOException {
        StringBuilder sb = new StringBuilder(2);
        sb.append(c);
        int n = this.read();
        if (n >= 0) {
            c = (char)n;
            if (c == '\n') {
                sb.append(c);
            } else {
                this.unread(n);
            }
        }
        return Char.createChar(CharType.EOL, sb);
    }

    protected Char readCharLF(char c) {
        return Char.createChar(CharType.EOL, c);
    }

    protected Char readCharString(char c) throws IOException {
        StringBuilder sb = new StringBuilder();
        block4: while (true) {
            sb.append(c);
            int n = this.read();
            if (n < 0) break;
            c = (char)n;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '!': 
                case '\"': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': {
                    this.unread(n);
                    break block4;
                }
                case '-': {
                    int m = this.read();
                    if (m == 45) {
                        this.unread(m);
                        this.unread(n);
                        break block4;
                    }
                    this.unread(m);
                }
                default: {
                    continue block4;
                }
            }
            break;
        }
        return Char.createChar(CharType.STRING, sb);
    }
}

