/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.html;

import java.util.HashMap;
import java.util.Map;

public class HtmlEscape {
    protected final Map<String, String> nameMap = new HashMap<String, String>();
    protected final Map<Character, String> entityMap = new HashMap<Character, String>();

    public HtmlEscape() {
        this(true, true);
    }

    public HtmlEscape(boolean dq, boolean sq) {
        this.addEntity("amp", "&");
        this.addEntity("lt", "<");
        this.addEntity("gt", ">");
        if (dq) {
            this.addEntity("quot", "\"");
        }
        if (sq) {
            this.addEntity("#39", "'");
        }
        this.addEntity("nbsp", null);
        this.addEntity("copy", null);
        this.addEntity("reg", null);
    }

    public void addEntity(String name, String entity) {
        this.nameMap.put(name, entity);
        if (entity == null) {
            return;
        }
        if (entity.length() != 1) {
            throw new IllegalArgumentException("entity.length != 1: " + entity);
        }
        this.entityMap.put(Character.valueOf(entity.charAt(0)), "&" + name + ";");
    }

    public void clearEntities() {
        this.nameMap.clear();
        this.entityMap.clear();
    }

    public String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length() * 2);
        int i = 0;
        while (i < s.length()) {
            String e;
            char c = s.charAt(i);
            if (c == '&' && (e = this.escapedAmp(s, i)) != null) {
                sb.append(c);
                sb.append(e);
                sb.append(';');
                i += e.length() + 2;
                continue;
            }
            String name = this.entityMap.get(Character.valueOf(c));
            if (name != null) {
                sb.append(name);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public String escapedAmp(String s, int pos) {
        int semi;
        if ((semi = s.indexOf(59, ++pos + 1)) < 0) {
            return null;
        }
        String t = s.substring(pos, semi);
        if (this.nameMap.containsKey(t)) {
            return t;
        }
        char c = t.charAt(0);
        switch (c) {
            case '#': {
                if (t.length() < 2) {
                    return null;
                }
                c = t.charAt(1);
                if (c == 'x' || c == 'X') {
                    if (HtmlEscape.isHexDigits(t, 2)) {
                        return t;
                    }
                    return null;
                }
                if (HtmlEscape.isDigits(t, 1)) {
                    return t;
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isDigits(String s, int first) {
        int len = s.length();
        int i = first;
        while (i < len) {
            if (!HtmlEscape.isDigit(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return first < len;
    }

    public static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isHexDigits(String s, int first) {
        int len = s.length();
        int i = first;
        while (i < len) {
            if (!HtmlEscape.isHexDigit(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return first < len;
    }

    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }
}

