/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.ant.types.htlex;

import java.io.IOException;
import jp.hishidama.ant.types.htlex.HtLexerConverter;
import jp.hishidama.ant.types.htlex.MatchEnum;
import jp.hishidama.ant.types.htlex.StringOpeEnum;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.token.ScriptToken;
import jp.hishidama.html.lexer.token.TextToken;
import jp.hishidama.html.lexer.token.Token;
import jp.hishidama.html.lexer.token.WordAtom;
import jp.hishidama.html.parser.elem.HtElement;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class TextType
extends DataType {
    protected NestedString text;
    protected NestedString newText = null;
    protected String newTextString = null;
    protected MatchEnum textMatch;
    protected StringOpeEnum textOpe = new StringOpeEnum("let");
    protected TextEnum textType = new TextEnum("text");
    protected boolean lines = false;
    protected HtLexerConverter converter;

    public void setText(String s) {
        this.createText().addText(s);
    }

    public NestedString createText() {
        if (this.text == null) {
            this.text = new NestedString();
        }
        return this.text;
    }

    public void setNewText(String s) {
        this.createNewText().addText(s);
    }

    public NestedString createNewText() {
        if (this.newText == null) {
            this.newText = new NestedString();
        }
        return this.newText;
    }

    public void setTextMatch(MatchEnum match) {
        this.textMatch = match;
    }

    public void setNewTextOperation(StringOpeEnum ope) {
        this.textOpe = ope;
    }

    public void setTextType(TextEnum type) {
        this.textType = type;
    }

    public void setLines(boolean b) {
        this.lines = b;
    }

    public void validate(HtLexerConverter conv) throws BuildException {
        this.converter = conv;
        if (this.text == null) {
            throw new BuildException("token attribute must be set.", this.getLocation());
        }
        if (this.text.getText().isEmpty()) {
            throw new BuildException("token attribute must not be an empty string.", this.getLocation());
        }
        if (this.textMatch == null) {
            this.textMatch = new MatchEnum("equals");
        }
        this.textMatch.setPattern(this.text.getText());
        this.textOpe.validate(this.textMatch, this.getLocation());
        if (this.newText != null) {
            this.newTextString = this.newText.getText();
        }
    }

    public boolean convert(TextToken token, HtElement he) {
        if (!this.textType.isType(token)) {
            return false;
        }
        if (this.lines) {
            return this.convertLines(token, he);
        }
        return this.contertLine(token, he);
    }

    protected boolean convertLines(TextToken token, HtElement he) {
        String o = token.getText();
        if (this.textMatch.matches(o)) {
            this.converter.logMatch(token);
            String n = this.convert(o, this.newTextString);
            if (!this.converter.equals(n, o)) {
                TextToken tt;
                HtLexer lexer = this.converter.getLexer(n);
                try {
                    try {
                        tt = lexer.parseText();
                    }
                    catch (IOException e) {
                        throw new BuildException((Throwable)e, this.getLocation());
                    }
                }
                finally {
                    try {
                        lexer.close();
                    }
                    catch (IOException iOException) {}
                }
                tt.calcLine(token.getLine());
                token.setText(tt);
                this.converter.logConvert("rep", token.getLine(), token);
                return true;
            }
        }
        return false;
    }

    protected boolean contertLine(TextToken token, HtElement he) {
        boolean ret = false;
        for (Token i : token) {
            String s;
            if (!(i instanceof WordAtom) || !this.textMatch.matches(s = i.getText())) continue;
            this.converter.logMatch(i);
            boolean r = this.updateWord(token, (WordAtom)i, s);
            if (!r) continue;
            this.converter.logConvert("rep", i.getLine(), i);
            ret |= r;
        }
        return ret;
    }

    protected boolean updateWord(TextToken text, WordAtom t, String o) {
        if (this.newTextString == null) {
            return false;
        }
        String n = this.convert(o, this.newTextString);
        if (!this.converter.equals(n, o)) {
            t.setString(n);
            return true;
        }
        return false;
    }

    protected String convert(String text, String newText) {
        return this.textOpe.convert(text, newText);
    }

    public class NestedString {
        private StringBuilder buf = new StringBuilder();

        public void addText(String val) {
            this.buf.append(val);
        }

        public String getText() {
            return this.buf.toString();
        }
    }

    public static class TextEnum
    extends EnumeratedAttribute {
        public static final String ALL = "all";
        public static final String TEXT = "text";
        public static final String SCRIPT = "script";

        public String[] getValues() {
            return new String[]{ALL, TEXT, SCRIPT};
        }

        public TextEnum() {
        }

        private TextEnum(String s) {
            this.setValue(s);
        }

        public boolean isType(TextToken token) {
            switch (this.getIndex()) {
                default: {
                    return true;
                }
                case 1: {
                    return !(token instanceof ScriptToken);
                }
                case 2: 
            }
            return token instanceof ScriptToken;
        }
    }
}

