/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.ant.types.htlex;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jp.hishidama.ant.types.htlex.AttrCondType;
import jp.hishidama.ant.types.htlex.HtLexerConverter;
import jp.hishidama.ant.types.htlex.MatchEnum;
import jp.hishidama.ant.types.htlex.PairTagEnum;
import jp.hishidama.ant.types.htlex.TagNewType;
import jp.hishidama.html.lexer.token.AttributeToken;
import jp.hishidama.html.lexer.token.Tag;
import jp.hishidama.html.parser.elem.HtElement;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.And;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.taskdefs.condition.ConditionBase;
import org.apache.tools.ant.taskdefs.condition.Not;
import org.apache.tools.ant.taskdefs.condition.Or;
import org.apache.tools.ant.types.DataType;

public class TagType
extends DataType {
    protected MatchEnum nameMatch;
    protected String tago;
    protected String tagc;
    protected PairTagEnum pair = new PairTagEnum("ignore");
    protected Condition attrCond = null;
    protected List<TagNewType> tagList = new ArrayList<TagNewType>();
    protected HtLexerConverter converter;
    protected Method GetConditionMethod;
    protected List<AttributeToken> tokenList;

    public void setName(String name) {
        if (this.nameMatch == null) {
            this.nameMatch = new MatchEnum("ignorecase");
        }
        this.nameMatch.setPattern(name);
    }

    public void setNameMatch(MatchEnum match) {
        if (this.nameMatch != null) {
            match.setPattern(this.nameMatch.getPatternString());
        }
        this.nameMatch = match;
    }

    public void setTagO(String s) {
        this.tago = s;
    }

    public void setTagC(String s) {
        this.tagc = s;
    }

    public void setPair(PairTagEnum p) {
        this.pair = p;
    }

    public void addConfigured(Condition cond) {
        if (this.attrCond == null) {
            this.attrCond = cond;
        } else if (this.attrCond instanceof And) {
            ((And)this.attrCond).add(cond);
        } else {
            And and = new And();
            and.setProject(this.getProject());
            and.add(this.attrCond);
            and.add(cond);
            this.attrCond = and;
        }
    }

    public void addConfiguredAnd(And cond) {
        this.addConfigured((Condition)cond);
    }

    public void addConfiguredOr(Or cond) {
        this.addConfigured((Condition)cond);
    }

    public void addConfiguredNot(Not cond) {
        this.addConfigured((Condition)cond);
    }

    public void addConfigured(TagNewType tag) {
        this.tagList.add(tag);
    }

    public void validate(HtLexerConverter conv) throws BuildException {
        this.converter = conv;
        if (this.pair.getIndex() >= 6) {
            this.converter.setUseParser(true);
        }
        if (this.attrCond != null) {
            this.validateCondition(this.attrCond);
        }
        for (TagNewType tt : this.tagList) {
            tt.validate(conv);
        }
    }

    protected void validateCondition(Condition c) throws BuildException {
        if (c == null) {
            throw new BuildException("condition must be set.", this.getLocation());
        }
        if (c instanceof AttrCondType) {
            AttrCondType ac = (AttrCondType)c;
            ac.validate(this);
            return;
        }
        if (c instanceof And || c instanceof Or || c instanceof Not) {
            Enumeration<Condition> n = this.getBaseConditions(c);
            while (n.hasMoreElements()) {
                this.validateCondition(n.nextElement());
            }
            return;
        }
        throw new BuildException(String.valueOf(c.getClass().getSimpleName()) + " can not be used.", this.getLocation());
    }

    protected Enumeration<Condition> getBaseConditions(Object obj) {
        try {
            if (this.GetConditionMethod == null) {
                this.GetConditionMethod = ConditionBase.class.getDeclaredMethod("getConditions", null);
                this.GetConditionMethod.setAccessible(true);
            }
            return (Enumeration)this.GetConditionMethod.invoke(obj, null);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    public boolean convert(Tag tag, HtElement he) {
        boolean ret = false;
        if (this.matches(tag, he)) {
            this.converter.logMatch(tag);
            for (TagNewType tt : this.tagList) {
                ret |= tt.convert(tag, he);
            }
        }
        return ret;
    }

    public List<AttributeToken> getTokenList() {
        return this.tokenList;
    }

    public boolean matches(Tag tag, HtElement he) {
        String name = tag.getName();
        if (!this.equalsName(name)) {
            return false;
        }
        if (!this.equalsTagO(tag.getTag1())) {
            return false;
        }
        if (!this.equalsTagC(tag.getTag2())) {
            return false;
        }
        if (this.attrCond != null) {
            this.tokenList = tag.getAttributeList();
            if (!this.attrCond.eval()) {
                return false;
            }
        }
        return this.pair.matches(tag, he);
    }

    protected boolean equalsName(String s) {
        if (this.nameMatch == null) {
            return true;
        }
        return this.nameMatch.matches(s);
    }

    protected boolean equalsTagO(String t) {
        if (this.tago == null) {
            return true;
        }
        return this.tago.equals(t);
    }

    protected boolean equalsTagC(String t) {
        if (this.tagc == null) {
            return true;
        }
        return this.tagc.equals(t);
    }
}

