/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.ant.types.htlex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import jp.hishidama.ant.types.htlex.StringPrintStream;
import jp.hishidama.ant.types.htlex.TagType;
import jp.hishidama.ant.types.htlex.TextType;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.token.ListToken;
import jp.hishidama.html.lexer.token.Tag;
import jp.hishidama.html.lexer.token.TextToken;
import jp.hishidama.html.lexer.token.Token;
import jp.hishidama.html.parser.elem.HtElement;
import jp.hishidama.html.parser.elem.HtElementUtil;
import jp.hishidama.html.parser.elem.HtListElement;
import jp.hishidama.html.parser.elem.HtTagElement;
import jp.hishidama.html.parser.elem.HtTokenElement;
import jp.hishidama.html.parser.rule.HtParser;
import jp.hishidama.html.parser.rule.HtParserManager;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.LogLevel;
import org.apache.tools.ant.util.FileUtils;

public class HtLexerConverter
extends DataType {
    protected Charset encoding;
    protected Charset outputEncoding;
    protected boolean force;
    protected boolean nowrite;
    protected int LogReadFileLevel = -1;
    protected int logMatchLevel = -1;
    protected int logUnmatchLevel = -1;
    protected int logWriteFileLevel = -1;
    protected int logConvertLevel = -1;
    protected boolean useParser = false;
    protected int dumpParseNotFixLevel = -1;
    protected final List<TagType> tagList = new ArrayList<TagType>();
    protected final List<TextType> textList = new ArrayList<TextType>();
    protected File rf;
    protected File wf;
    private boolean matched;
    private boolean convert;
    private boolean writeFile;
    protected HtLexer lexer = this.createLexer();
    protected FileUtils fu;
    private StringPrintStream sps = null;

    public void setEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    public void setOutputEncoding(String encoding) {
        this.outputEncoding = Charset.forName(encoding);
    }

    public void setForce(boolean b) {
        this.force = b;
    }

    public void setNoWrite(boolean b) {
        this.nowrite = b;
    }

    public void setLogReadFile(LogLevel level) {
        this.LogReadFileLevel = level.getLevel();
    }

    public void setLogMatch(LogLevel level) {
        this.logMatchLevel = level.getLevel();
    }

    public void setLogUnmatch(LogLevel level) {
        this.logUnmatchLevel = level.getLevel();
    }

    public void setLogConvert(LogLevel level) {
        this.logConvertLevel = level.getLevel();
    }

    public void setLogWriteFile(LogLevel level) {
        this.logWriteFileLevel = level.getLevel();
    }

    public void setUseParser(boolean b) {
        this.useParser = b;
    }

    public void setDumpParseNotFix(LogLevel level) {
        this.dumpParseNotFixLevel = level.getLevel();
        this.setUseParser(true);
    }

    public void addConfigured(TagType tag) {
        this.tagList.add(tag);
    }

    public void addConfigured(TextType text) {
        this.textList.add(text);
    }

    public void validate() throws BuildException {
        for (TagType tagType : this.tagList) {
            tagType.validate(this);
        }
        for (TextType textType : this.textList) {
            textType.validate(this);
        }
    }

    public void logReadFile(String msg, int level) {
        if (level >= 0) {
            this.log(String.valueOf(msg) + this.rf.getAbsolutePath(), level);
        }
    }

    public void logMatch(Token token) {
        if (this.logMatchLevel >= 0) {
            if (!this.matched) {
                this.logReadFile("match: ", this.logMatchLevel);
            }
            this.log(String.valueOf(token.getLine()) + "\t" + token.getText(), this.logMatchLevel);
        }
        this.matched = true;
    }

    public void logUnmatch() {
        if (this.logUnmatchLevel >= 0) {
            this.logReadFile("unmatch: ", this.logUnmatchLevel);
        }
    }

    public void logConvert(String msg, int line, Token token) {
        if (this.logConvertLevel >= 0) {
            if (!this.convert) {
                this.logReadFile("conv: ", this.logConvertLevel);
            }
            StringBuilder sb = new StringBuilder(32);
            sb.append(msg);
            sb.append(": ");
            sb.append(line);
            sb.append("\t");
            sb.append(token.getText());
            this.log(sb.toString(), this.logConvertLevel);
        }
        this.convert = true;
    }

    public void logWriteFile(File f) {
        if (this.logWriteFileLevel >= 0 && !this.writeFile) {
            this.log("write: " + f.getAbsolutePath(), this.logWriteFileLevel);
        }
        this.writeFile = true;
    }

    protected HtLexer createLexer() {
        return new HtLexer();
    }

    public HtLexer getLexer(String s) {
        this.lexer.setTarget(s);
        return this.lexer;
    }

    public void execute(File rf, File wf, File bf) throws BuildException {
        boolean changed;
        this.rf = rf;
        this.wf = wf;
        this.matched = false;
        this.convert = false;
        this.writeFile = false;
        Reader r = this.createReader();
        ListToken tlist = this.createToken(r);
        HtListElement elist = this.createElement(tlist);
        boolean bl = changed = elist != null ? this.convert(elist) : this.convert(tlist);
        if (!this.matched) {
            this.logUnmatch();
        }
        if (changed || this.force) {
            Writer w;
            if (bf != null) {
                this.backup(rf, bf);
            }
            if ((w = this.createWriter()) != null) {
                try {
                    try {
                        if (elist != null) {
                            elist.writeTo(w);
                        } else {
                            tlist.writeTo(w);
                        }
                    }
                    catch (IOException e) {
                        throw new BuildException((Throwable)e, this.getLocation());
                    }
                }
                finally {
                    try {
                        w.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected ListToken createToken(Reader r) {
        ListToken tlist;
        try {
            try {
                this.lexer.setTarget(r);
                tlist = this.lexer.parse();
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e, this.getLocation());
            }
        }
        finally {
            try {
                this.lexer.close();
            }
            catch (IOException iOException) {}
        }
        tlist.calcLine(1);
        return tlist;
    }

    protected HtListElement createElement(ListToken tlist) {
        HtListElement elist = null;
        if (this.useParser) {
            HtParser parser = new HtParserManager().getDefaultParser();
            elist = parser.parse(tlist);
        }
        return elist;
    }

    public File getReadFile() {
        return this.rf;
    }

    protected void backup(File rf, File bf) {
        File parent;
        if (this.nowrite) {
            return;
        }
        if (this.fu == null) {
            this.fu = FileUtils.getFileUtils();
        }
        if (!(parent = bf.getParentFile()).exists()) {
            parent.mkdirs();
        }
        try {
            this.fu.copyFile(rf, bf, null, true, true);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    protected Reader createReader() {
        this.logReadFile("read: ", this.LogReadFileLevel);
        try {
            if (this.encoding == null) {
                return new FileReader(this.rf);
            }
            return new InputStreamReader((InputStream)new FileInputStream(this.rf), this.encoding);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    protected Writer createWriter() {
        Charset cs;
        File f = this.wf != null ? this.wf : this.rf;
        this.logWriteFile(f);
        if (this.nowrite) {
            return null;
        }
        File parent = f.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if ((cs = this.outputEncoding) == null) {
            cs = this.encoding;
        }
        try {
            if (cs == null) {
                return new FileWriter(f);
            }
            return new OutputStreamWriter((OutputStream)new FileOutputStream(f), cs);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    public boolean convert(ListToken tlist) {
        boolean ret = false;
        for (Token t : tlist) {
            ret |= this.convertToken(t, null);
        }
        return ret;
    }

    public boolean convert(HtListElement elist) {
        boolean ret = false;
        this.dumpParseNotFix(elist);
        return ret |= this.convertLoop(elist);
    }

    protected boolean convertLoop(HtElement he) {
        Tag etag;
        Tag stag;
        if (he instanceof HtTokenElement) {
            HtTokenElement te = (HtTokenElement)he;
            Token t = te.getToken();
            if (t != null) {
                return this.convertToken(t, he);
            }
            return false;
        }
        boolean ret = false;
        HtTagElement te = null;
        if (he instanceof HtTagElement && (stag = (te = (HtTagElement)he).getStartTag()) != null) {
            ret |= this.convertTag(stag, he);
        }
        HtListElement elist = (HtListElement)he;
        int i = 0;
        while (i < elist.size()) {
            HtElement e = elist.get(i);
            if (e != null) {
                ret |= this.convertLoop(e);
            }
            ++i;
        }
        if (te != null && (etag = te.getEndTag()) != null) {
            ret |= this.convertTag(etag, he);
        }
        return ret;
    }

    protected StringPrintStream initPrintStream() {
        if (this.sps == null) {
            this.sps = new StringPrintStream();
        }
        this.sps.clear();
        return this.sps;
    }

    protected void dumpParseNotFix(HtListElement elist) {
        if (this.dumpParseNotFixLevel >= 0) {
            StringPrintStream ps = this.initPrintStream();
            HtElementUtil.dumpNotFix(elist, ps);
            if (!ps.isEmpty()) {
                this.logReadFile("notFix: ", this.dumpParseNotFixLevel);
                String s = ps.toString();
                this.log(s, this.dumpParseNotFixLevel);
            }
        }
    }

    protected boolean convertToken(Token t, HtElement he) {
        if (t instanceof Tag) {
            Tag tag = (Tag)t;
            return this.convertTag(tag, he);
        }
        if (t instanceof TextToken) {
            TextToken text = (TextToken)t;
            return this.convertText(text, he);
        }
        return false;
    }

    public boolean convertTag(Tag tag, HtElement he) {
        boolean ret = false;
        for (TagType i : this.tagList) {
            ret |= i.convert(tag, he);
        }
        return ret;
    }

    public boolean convertText(TextToken text, HtElement he) {
        boolean ret = false;
        for (TextType i : this.textList) {
            ret |= i.convert(text, he);
        }
        return ret;
    }

    public boolean equals(String s1, String s2) {
        if (s1 == null || s1.isEmpty()) {
            return s2 == null || s2.isEmpty();
        }
        return s1.equals(s2);
    }
}

