/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.ant.types.htlex;

import org.apache.tools.ant.types.EnumeratedAttribute;

public class CaseEnum
extends EnumeratedAttribute {
    public static final String SAME = "same";
    public static final String LOWER = "lower";
    public static final String UPPER = "upper";
    public static final String PROPER = "proper";
    protected Converter c = null;

    public String[] getValues() {
        return new String[]{SAME, LOWER, UPPER, PROPER};
    }

    public CaseEnum() {
    }

    public CaseEnum(String s) {
        this.setValue(s);
    }

    public String convert(String s) {
        if (s == null) {
            return null;
        }
        if (this.c == null) {
            switch (this.getIndex()) {
                case 0: {
                    this.c = new Same();
                    break;
                }
                case 1: {
                    this.c = new Lower();
                    break;
                }
                case 2: {
                    this.c = new Upper();
                    break;
                }
                case 3: {
                    this.c = new Proper();
                }
            }
        }
        return this.c.convert(s);
    }

    protected static interface Converter {
        public String convert(String var1);
    }

    protected static class Lower
    implements Converter {
        protected Lower() {
        }

        @Override
        public String convert(String s) {
            return s.toLowerCase();
        }
    }

    protected static class Proper
    implements Converter {
        protected Proper() {
        }

        @Override
        public String convert(String s) {
            boolean first = true;
            char[] ca = s.toCharArray();
            int i = 0;
            while (i < ca.length) {
                char l;
                char c = ca[i];
                char u = Character.toUpperCase(c);
                if (u != (l = Character.toLowerCase(c))) {
                    if (first) {
                        ca[i] = u;
                        first = false;
                    } else {
                        ca[i] = l;
                    }
                } else {
                    first = true;
                }
                ++i;
            }
            return new String(ca);
        }
    }

    protected static class Same
    implements Converter {
        protected Same() {
        }

        @Override
        public String convert(String s) {
            return s;
        }
    }

    protected static class Upper
    implements Converter {
        protected Upper() {
        }

        @Override
        public String convert(String s) {
            return s.toUpperCase();
        }
    }
}

