/*
 * Decompiled with CFR 0.152.
 */
package jp.hishidama.ant.types.htlex;

import java.io.IOException;
import jp.hishidama.ant.types.htlex.AttrOpeType;
import jp.hishidama.ant.types.htlex.CaseEnum;
import jp.hishidama.ant.types.htlex.HtLexerConverter;
import jp.hishidama.ant.types.htlex.HtmlEscapeEnum;
import jp.hishidama.ant.types.htlex.StringOpeEnum;
import jp.hishidama.html.HtmlEscape;
import jp.hishidama.html.lexer.rule.HtLexer;
import jp.hishidama.html.lexer.token.AttributeToken;
import jp.hishidama.html.lexer.token.Tag;
import jp.hishidama.html.lexer.token.ValueToken;
import org.apache.tools.ant.BuildException;

public class AttrNewType
extends AttrOpeType {
    protected String newName;
    protected StringOpeEnum nameOpe = new StringOpeEnum("let");
    protected CaseEnum nameCase;
    protected String newLet;
    protected String newValue;
    protected StringOpeEnum valueOpe = new StringOpeEnum("let");
    protected CaseEnum valueCase;
    protected HtmlEscape htmlEscape;
    protected String newQuote;

    public void setNewName(String name) {
        this.newName = name;
    }

    public void setNewNameOperation(StringOpeEnum ope) {
        this.nameOpe = ope;
    }

    public void setNewNameCase(CaseEnum c) {
        this.nameCase = c;
    }

    public void setNewLet(String s) {
        this.newLet = s;
    }

    public void setNewValue(String s) {
        this.newValue = s;
    }

    public void setNewValueOperation(StringOpeEnum ope) {
        this.valueOpe = ope;
    }

    public void setNewValueCase(CaseEnum c) {
        this.valueCase = c;
    }

    public void setNewValueHtmlEscape(HtmlEscapeEnum esc) {
        this.htmlEscape = new HtmlEscape(esc.isDq(), esc.isSq());
    }

    public void setNewQuote(String s) {
        this.newQuote = s;
    }

    @Override
    public void validate(HtLexerConverter conv) throws BuildException {
        super.validate(conv);
        if (this.newValue != null) {
            if (this.newLet == null) {
                this.newLet = "=";
            }
            if (this.newQuote == null) {
                this.newQuote = "\"";
            }
        }
        if (this.newName != null) {
            this.nameOpe.validate(this.nameMatch, this.getLocation());
        }
        if (this.newValue != null) {
            this.valueOpe.validate(this.valueMatch, this.getLocation());
        }
    }

    protected boolean update(Tag tag, AttributeToken a) {
        boolean ret = false;
        ret |= this.updateName(tag, a);
        ret |= this.updateLet(tag, a);
        ret |= this.updateValue(tag, a);
        if (ret |= this.updateQuote(tag, a)) {
            int line = a.getLine();
            if (line <= 0) {
                line = tag.getLine();
            }
            this.htmlConverter.logConvert("rep", line, a);
        }
        return ret;
    }

    protected boolean updateName(Tag tag, AttributeToken a) {
        String o;
        if (this.newName == null && this.nameCase == null) {
            return false;
        }
        String n = o = a.getName();
        if (this.newName != null) {
            n = this.nameOpe.convert(n, this.newName);
        }
        if (this.nameCase != null) {
            n = this.nameCase.convert(n);
        }
        if (!this.htmlConverter.equals(n, o)) {
            a.setName(n);
            return true;
        }
        return false;
    }

    protected boolean updateLet(Tag tag, AttributeToken a) {
        if (this.newLet == null) {
            return false;
        }
        String o = a.getLet();
        if (!this.htmlConverter.equals(this.newLet, o)) {
            a.setLet(this.newLet);
            return true;
        }
        return false;
    }

    protected boolean updateValue(Tag tag, AttributeToken a) {
        String o;
        if (this.newValue == null && this.valueCase == null && this.htmlEscape == null) {
            return false;
        }
        String n = o = a.getValue();
        if (this.newValue != null) {
            n = this.valueOpe.convert(n, this.newValue);
        }
        if (this.valueCase != null) {
            n = this.valueCase.convert(n);
        }
        if (this.htmlEscape != null) {
            n = this.htmlEscape.escape(n);
        }
        if (!this.htmlConverter.equals(n, o)) {
            ValueToken vt;
            String q1 = this.newQuote;
            String q2 = this.newQuote;
            ValueToken ot = a.getValueToken();
            if (ot != null) {
                q1 = ot.getQuote1();
                q2 = ot.getQuote2();
            }
            HtLexer lexer = this.htmlConverter.getLexer(n);
            try {
                try {
                    vt = lexer.parseAttrValue(q1, q2);
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e, this.getLocation());
                }
            }
            finally {
                try {
                    lexer.close();
                }
                catch (IOException iOException) {}
            }
            if (ot != null) {
                vt.calcLine(ot.getLine());
            }
            a.setValue(vt);
            return true;
        }
        return false;
    }

    protected boolean updateQuote(Tag tag, AttributeToken a) {
        String o2;
        if (this.newQuote == null) {
            return false;
        }
        ValueToken vt = a.getValueToken();
        if (vt == null) {
            vt = new ValueToken();
            a.setValue(vt);
        }
        boolean ret = false;
        String o1 = vt.getQuote1();
        if (!this.htmlConverter.equals(this.newQuote, o1)) {
            vt.setQuote1(this.newQuote);
            ret |= true;
        }
        if (!this.htmlConverter.equals(this.newQuote, o2 = vt.getQuote2())) {
            vt.setQuote2(this.newQuote);
            ret |= true;
        }
        return ret;
    }
}

