package example.flow;

import example.entity.AverageEntity;
import example.entity.KamokuEntity;
import example.entity.KamokuTotalEntity;
import example.entity.ScoreEntity;
import example.entity.SigmaEntity;
import example.entity.TenEntity;
import jp.co.cac.azarea.cluster.Main;
import jp.co.cac.azarea.cluster.entity.format.DelimitedEntityFormat;
import jp.co.cac.azarea.cluster.planner.job.EntityFlow;
import jp.co.cac.azarea.cluster.planner.job.SimpleEntityFlowManager;
import jp.co.cac.azarea.cluster.planner.operation.Conversion;
import jp.co.cac.azarea.cluster.planner.operation.EntityFile;
import jp.co.cac.azarea.cluster.planner.operation.Group;
import jp.co.cac.azarea.cluster.planner.operation.UniqueJoin;
import jp.co.cac.azarea.cluster.util.Generated;

@Generated("AZAREA-Cluster 1.0")
public class ScoreFlow extends EntityFlow {

	@Override
	protected void initialize() {
		getEntityManager().defineEntityFormat("TenEntity.txt",
				DelimitedEntityFormat.delimiter(","));

		EntityFile<TenEntity> entity1 = getInput(TenEntity.class);
		Conversion<TenEntity, KamokuEntity> split = new Conversion<TenEntity, KamokuEntity>(
				entity1) {
			@Override
			protected void convert(TenEntity entity) {
				// Ȗږ̐тɕ
				output(createKamoku(entity, 0, entity.suugaku));
				output(createKamoku(entity, 1, entity.kokugo));
				output(createKamoku(entity, 2, entity.rika));
				output(createKamoku(entity, 3, entity.shakai));
				output(createKamoku(entity, 4, entity.eigo));
				output(createKamoku(entity, 5, entity.suugaku + entity.kokugo
						+ entity.rika + entity.shakai + entity.eigo));
			}

			private KamokuEntity createKamoku(TenEntity entity, int kamokuId,
					int ten) {
				KamokuEntity result = new KamokuEntity();
				result.studentId = entity.studentId;
				result.studentName = entity.studentName;
				result.kamokuId = kamokuId;
				result.ten = ten;
				return result;
			}
		};
		Conversion<KamokuEntity, KamokuTotalEntity> entity2 = new Conversion<KamokuEntity, KamokuTotalEntity>(
				split) {
			@Override
			protected void convert(KamokuEntity entity) {
				KamokuTotalEntity result = new KamokuTotalEntity();
				result.kamokuId = entity.kamokuId;
				result.ten = entity.ten;
				result.count = 1;
				output(result);
			}
		};
		Group<KamokuTotalEntity> entity3 = new Group<KamokuTotalEntity>(
				entity2, "kamokuId") {
			@Override
			protected void doSummarize(KamokuTotalEntity summary,
					KamokuTotalEntity another) {
				// Ȗږ̍v_Zo
				summary.ten += another.ten;
				summary.count += another.count;
			}
		};
		Conversion<KamokuTotalEntity, AverageEntity> entity4 = new Conversion<KamokuTotalEntity, AverageEntity>(
				entity3) {
			@Override
			protected void convert(KamokuTotalEntity entity) {
				// Ȗږ̕ϓ_Zo
				AverageEntity result = new AverageEntity();
				result.kamokuId = entity.kamokuId;
				result.count = entity.count;
				result.average = (double) entity.ten / entity.count;
				output(result);
			}
		};
		UniqueJoin<KamokuEntity, AverageEntity, SigmaEntity> entity5 = new UniqueJoin<KamokuEntity, AverageEntity, SigmaEntity>(
				split, entity4, "kamokuId") {
			@Override
			protected void merge(KamokuEntity main, AverageEntity sub) {
				SigmaEntity result = new SigmaEntity();
				result.kamokuId = main.kamokuId;
				result.average = sub.average;
				result.count = sub.count;
				result.sum = Math.pow(main.ten - sub.average, 2);
				output(result);
			}

			@Override
			protected void merge(KamokuEntity main) {
				// ԂA}b`̂ƂɌĂ΂
				// ͕K}b`͂
				throw new IllegalStateException(main.toString());
			}
		};
		Group<SigmaEntity> entity6 = new Group<SigmaEntity>(entity5, "kamokuId") {
			@Override
			protected void doSummarize(SigmaEntity summary, SigmaEntity another) {
				summary.sum += another.sum;
			}
		};
		Conversion<SigmaEntity, SigmaEntity> entity7 = new Conversion<SigmaEntity, SigmaEntity>(
				entity6) {
			@Override
			protected void convert(SigmaEntity entity) {
				// Ȗږ̕W΍Zo
				SigmaEntity result = new SigmaEntity();
				result.copyFrom(entity);
				result.sigma = Math.sqrt(entity.sum / entity.count);
				output(result);
			}
		};
		UniqueJoin<KamokuEntity, SigmaEntity, ScoreEntity> entity8 = new UniqueJoin<KamokuEntity, SigmaEntity, ScoreEntity>(
				split, entity7, "kamokuId") {
			@Override
			protected void merge(KamokuEntity main, SigmaEntity sub) {
				// wEȖږ̕΍lZo
				ScoreEntity result = new ScoreEntity();
				result.copyFrom(sub);
				result.copyFrom(main);
				result.kamokuName = Ȗږ[main.kamokuId];
				result.score = (main.ten - sub.average) * 10 / sub.sigma + 50;
				output(result);
			}

			@Override
			protected void merge(KamokuEntity main) {
				// ԂA}b`̂ƂɌĂ΂
				// ͕K}b`͂
				throw new IllegalStateException(main.toString());
			}
		};
		setOutput(entity8);
	}

	static final String Ȗږ[] = { "w", "", "", "Љ", "p", "v" };

	public static void main(String[] args) throws Exception {
		Main.execute(SimpleEntityFlowManager.class.getName(),
				ScoreFlow.class.getName(), args);
	}

}
