`timescale 1ns/1ns

module test;

reg clk;
integer cycle ;
reg [159:0] pc_1, Fetched_1, Executed_1 ;
reg [159:0] pc_2, Fetched_2, Executed_2 ;
reg [159:0] pc_3, Fetched_3, Executed_3 ;
reg [159:0] pc_4, Fetched_4, Executed_4 ;
reg [159:0] pc_5, Fetched_5, Executed_5 ;
reg int_in , gie_1, sample_1 ;
reg gie_2, sample_2 ;
reg gie_3, sample_3 ;
reg gie_4, sample_4 ;
reg gie_5, sample_5 ;
wire interrupt_1 ;
wire interrupt_2 ;
wire interrupt_3 ;
wire interrupt_4 ;
wire interrupt_5 ;

    assign interrupt_1 = int_in & gie_1 ;
    assign interrupt_2 = int_in & gie_2 ;
    assign interrupt_3 = int_in & gie_3 ;
    assign interrupt_4 = int_in & gie_4 ;
    assign interrupt_5 = int_in & gie_5 ;

    initial begin 
	cycle = -1 ;
        clk = 0 ;
        repeat( 6 ) begin
            #50 clk = ~clk ;
            #50 clk = ~clk ;
        end // repat
        $stop ; //:finish ;
    end // initial
    always@( posedge clk ) begin
	cycle = cycle +1 ;
    end // always

    ////
    //// Normal case
    ////
    initial begin // Normal case
	sample_1 <= 1'b0 ;
	int_in <= 1'b0 ;
	gie_1 <= 1'b1 ;
	@(posedge clk)
	    #5 pc_1 <= "PC" ;
	     Fetched_1 <= "Inst(PC)" ;
	     Executed_1 <= "Inst(PC-1)" ;
	@(posedge clk)
	#5 pc_1 <= "PC+1" ;
	     Fetched_1 <= "Inst(PC+1)" ;
	     Executed_1 <= "Inst(PC)" ;
	     int_in <= 1'b1 ;
	@(posedge clk)
	#5 pc_1 <= "PC+1 " ;
	     Fetched_1 <= "Inst(PC+1)" ;
	     Executed_1 <= "Dummy" ;
	@(posedge clk)
	#5 pc_1 <= "0004" ;
	     Fetched_1 <= "Inst(0004)" ;
	     Executed_1 <= "Dummy" ;
	     gie_1 <= 1'b0 ;
	@(posedge clk)
	#5 pc_1 <= "0005" ;
	     Fetched_1 <= "Inst(0005)" ;
	     Executed_1 <= "Inst(0004)" ;
    end // initial
    always@( posedge clk) begin
	if( interrupt_1 == 1'b1 ) begin
	    sample_1 = 1'b1 ;
	    #2 sample_1 =1'b0 ;
	end //if
    end // always


    ////
    //// Goto case 
    ////
    initial begin // Normal case
	sample_2 <= 1'b0 ;
	int_in <= 1'b0 ;
	gie_2 <= 1'b1 ;
	@(posedge clk)
	    #5 pc_2 <= "PC" ;
	     Fetched_2 <= "Goto A" ;
	     Executed_2 <= "Inst(PC-1)" ;
	@(posedge clk)
	#5 pc_2 <= "PC+1" ;
	     Fetched_2 <= "Inst(PC+1)" ;
	     Executed_2 <= "Goto A" ;
	     int_in <= 1'b1 ;
	@(posedge clk)
	#5 pc_2 <= "A" ;
	     Fetched_2 <= "Inst(A)" ;
	     Executed_2 <= "Dummy" ;
	@(posedge clk)
	#5 pc_2 <= "0004" ;
	     Fetched_2 <= "Inst(0004)" ;
	     Executed_2 <= "Dummy" ;
	     gie_2 <= 1'b0 ;
	@(posedge clk)
	#5 pc_2 <= "0005" ;
	     Fetched_2 <= "Inst(0005)" ;
	     Executed_2 <= "Inst(0004)" ;
    end // initial
    always@( posedge clk) begin
	if( interrupt_2 == 1'b1 ) begin
	    sample_2 = 1'b1 ;
	    #2 sample_2 =1'b0 ;
	end //if
    end // always


    ////
    //// case BCF INTCON,GIE
    ////
    initial begin // Normal case
	sample_3 <= 1'b0 ;
	int_in <= 1'b0 ;
	gie_3 <= 1'b1 ;
	@(posedge clk)
	    #5 pc_3 <= "PC" ;
	     Fetched_3 <= "BCF INTCON,GIE" ;
	     Executed_3 <= "Inst(PC-1)" ;
	@(posedge clk)
	#5 pc_3 <= "PC+1" ;
	     Fetched_3 <= "Inst(PC+1)" ;
	     Executed_3 <= "BCF INTCON,GIE" ;
	     int_in <= 1'b1 ;
	@(posedge clk)
	#5 pc_3 <= "PC+1 " ;
	     Fetched_3 <= "INST(PC+1)" ;
	     Executed_3 <= "Dummy" ;
	     gie_3 <= 1'b0 ;
	@(posedge clk)
	#5 pc_3 <= "PC+2" ;
	     Fetched_3 <= "Inst(PC+2)" ;
	     Executed_3 <= "Inst(PC+1)" ;
	@(posedge clk)
	#5 pc_3 <= "PC+3" ;
	     Fetched_3 <= "Inst(PC+3)" ;
	     Executed_3 <= "InstPC+2)" ;
    end // initial
    always@( posedge clk) begin
	if( interrupt_3 == 1'b1 ) begin
	    sample_3 = 1'b1 ;
	    #2 sample_3 =1'b0 ;
	end //if
    end // always




    ////
    //// case BTFSC f,b  No Skip
    ////
    initial begin // Normal case
	sample_4 <= 1'b0 ;
	int_in <= 1'b0 ;
	gie_4 <= 1'b1 ;
	@(posedge clk)
	    #5 pc_4 <= "PC" ;
	     Fetched_4 <= "BTFSC f,b" ;
	     Executed_4 <= "Inst(PC-1)" ;
	@(posedge clk)
	#5 pc_4 <= "PC+1" ;
	     Fetched_4 <= "Inst(PC+1)" ;
	     Executed_4 <= "BTFSC f,b" ;
	     int_in <= 1'b1 ;
	@(posedge clk)
	#5 pc_4 <= "PC+1 " ;
	     Fetched_4 <= "Inst(PC+1)" ;
	     Executed_4 <= "Dummy" ;
	@(posedge clk)
	#5 pc_4 <= "0004" ;
	     Fetched_4 <= "Inst(0004)" ;
	     Executed_4 <= "Dummy" ;
	     gie_4 <= 1'b0 ;
	@(posedge clk)
	#5 pc_4 <= "0005" ;
	     Fetched_4 <= "Inst(0005)" ;
	     Executed_4 <= "Inst(0004)" ;
    end // initial
    always@( posedge clk) begin
	if( interrupt_4 == 1'b1 ) begin
	    sample_4 = 1'b1 ;
	    #2 sample_4 =1'b0 ;
	end //if
    end // always




    ////
    //// case BTFSC f,b  Skip
    ////
    initial begin // Normal case
	sample_5 <= 1'b0 ;
	int_in <= 1'b0 ;
	gie_5 <= 1'b1 ;
	@(posedge clk)
	    #5 pc_5 <= "PC" ;
	     Fetched_5 <= "BTFSC f,b" ;
	     Executed_5 <= "Inst(PC-1)" ;
	@(posedge clk)
	#5 pc_5 <= "PC+1" ;
	     Fetched_5 <= "Inst(PC+1)" ;
	     Executed_5 <= "BTFSC f,b" ;
	     int_in <= 1'b1 ;
	@(posedge clk)
	#5 pc_5 <= "PC+2 " ;
	     Fetched_5 <= "Inst(PC+2)" ;
	     Executed_5 <= "Dummy" ;
	@(posedge clk)
	#5 pc_5 <= "0004" ;
	     Fetched_5 <= "Inst(0004)" ;
	     Executed_5 <= "Dummy" ;
	     gie_5 <= 1'b0 ;
	@(posedge clk)
	#5 pc_5 <= "0005" ;
	     Fetched_5 <= "Inst(0005)" ;
	     Executed_5 <= "Inst(0004)" ;
    end // initial
    always@( posedge clk) begin
	if( interrupt_5 == 1'b1 ) begin
	    sample_5 = 1'b1 ;
	    #2 sample_5 =1'b0 ;
	end //if
    end // always






















endmodule // test
