#!/usr/local/bin/perl
#
# codabarx.pl: Output HTML of "CODABAR" barcode
#
# Copyright(c) 1999 Yoshio Murase
# This is free and open-source software.
#
# Version:  1.1
# Date:     1999.11.24
# Author:   Yoshio Murase
# Url:      http://www.ne.jp/asahi/ai/yoshio/tool/codabar/codabarhtm.pl
#
# Usage: 
#   codabarhtm.pl [file]
#
# "CODABAR" and "NW-7" are same kind of barcode.
#

@code_elements{
    "0",  "1",  "2",  "3",  "4",
    "5",  "6",  "7",  "8",  "9",
    q|-|, q|$|, q|:|, q|/|, q|.|,
    q|+|,  "A",  "B",  "C",  "D" } =
    (
    "0000011", "0000110", "0001001", "1100000", "0010010",
    "1000010", "0100001", "0100100", "0110000", "1001000",
    "0001100", "0011000", "1000101", "1010001", "1010100",
    "0010101", "0011010", "0101001", "0001011", "0001110" );

# Image file
$black_img = "black3x3.gif";
$white_img = "white3x3.gif";

# You can change these parameter
# "$base_number" may have to be more than 0.5
$wide_narrow_ratio = 3;
$margin_ratio = 20;
$height_ratio = 70;
$base_number = 0.5;

# start/stop codes are A|B|C|D;
$start_code = "A";
$stop_code = "A";

# Do not change bellow
$narrow_half = $base_number;
$narrow = $narrow_half * 2;
$wide_half = $base_number * $wide_narrow_ratio;
$wide = $wide_half * 2;

$height = $height_ratio * $base_number;
$height_margin = $height + ($margin_ratio * $base_number);

&top;
while(<>) {

    &before;
    $input_codes = $_;

    chomp $input_codes;
    $count = 0;
    $barcode = $start_code . $input_codes. $stop_code;
    @codes = split(//,$barcode);
    while( @codes ){

        $element = "0";
        &print_space($element);

        $code = shift(@codes);
        @elements = split(//, $code_elements{$code});
        while( @elements ){

            $element = shift(@elements);            
            &print_line($element);

            break   if ( ! @elements );

            $element = shift(@elements);
            &print_space($element);
        }
    }
    $width = $count     if ($width < $count );
    &after;
    &before;
    &print_codes;
    &after;
}

&bottom;

sub print_codes{
    print $barcode;
}

sub print_line{
    $element = shift;
    &narrow_line    if ( $element eq "0" );
    &wide_line      if ( $element eq "1" );
}

sub print_space{
    $element = shift;
    &narrow_space    if ( $element eq "0" );
    &wide_space      if ( $element eq "1" );
}

sub narrow_line{
    print qq(<IMG SRC="$black_img" width="$narrow") . "\n";
    print qq(height="$height">);
}

sub narrow_space{
    print qq(<IMG SRC="$white_img" width="$narrow") . "\n";
    print qq(height="$height_margin">);
}

sub wide_line{
    print qq(<IMG SRC="$black_img" width="$wide") . "\n";
    print qq(height="$height">);
}

sub wide_space{
    print qq(<IMG SRC="$white_img" width="$wide") . "\n";
    print qq(height="$height_margin">);
}

sub top{
    print <<__END__;
<HTML>
<BODY>
<TABLE border="0" bgcolor="#FFFFFF">
<TR><TD>
__END__
}

sub bottom{
    print <<__END__;
</TD></TR>
</TABLE>
</BODY>
</HTML>
__END__
}

sub before{
    print <<__END__;
<TR><TD>
__END__
}

sub after{
    print <<__END__;
</TD></TR>
__END__
}

