#!/usr/local/bin/perl
#
# codabar.pl: Output PostScript of "CODABAR" barcode
#
# Copyright(c) 1999 Yoshio Murase
# This is free and open-source software.
#
# Version:	1.1
# Date:		1999.11.21/2000.01.09
# Author:	Yoshio Murase
# Url:		http://www.ne.jp/asahi/ai/yoshio/tool/codabar/codabar.pl
#
# Usage: 
#	codabar.pl [file]
#
# "CODABAR" or "NW-7" is a kind of barcode.
#

@code_elements{
	"0",  "1",	"2",  "3",	"4",
	"5",  "6",	"7",  "8",	"9",
	q|-|, q|$|, q|:|, q|/|, q|.|,
	q|+|,  "A",	 "B",  "C",	 "D" } =
	(
	"0000011", "0000110", "0001001", "1100000", "0010010",
	"1000010", "0100001", "0100100", "0110000", "1001000",
	"0001100", "0011000", "1000101", "1010001", "1010100",
	"0010101", "0011010", "0101001", "0001011", "0001110" );

# You can change these parameter.
$wide_narrow_ratio = 3.0;
$height_ratio = 50;
$margin_ratio = 15;
$base_number = 5;
$scale = 0.2;
$showpage = q|showpage|;

# start/stop codes are A|B|C|D;
$start_code = "A";
$stop_code = "A";

# Do not change bellow
$narrow_half = $base_number;
$narrow = $narrow_half * 2;
$wide_half = $base_number * $wide_narrow_ratio;
$wide = $wide_half * 2;

$height = $height_ratio * $base_number;
$height_margin = $height + ($margin_ratio * $base_number);

&top;
while(<>) {
	$input_codes = $_;

	chomp $input_codes;
	$count = 0;
	$barcode = $start_code . $input_codes. $stop_code;
	@codes = split(//,$barcode);
	while( @codes ){

		$element = "0";
		&print_space($element);

		$code = shift(@codes);
		@elements = split(//, $code_elements{$code});
		while( @elements ){

			$element = shift(@elements);			
			&print_line($element);

			break	if ( ! @elements );

			$element = shift(@elements);
			&print_space($element);
		}
	}
	$width = $count		if ($width < $count );
	&next;
}

&bottom;

sub print_line{
	$element = shift;
	&narrow_line	if ( $element eq "0" );
	&wide_line		if ( $element eq "1" );
}

sub print_space{
	$element = shift;
	&narrow_space	 if ( $element eq "0" );
	&wide_space		 if ( $element eq "1" );
}

sub narrow_line{
	print <<__END__;
	% narrow line
$narrow_half 0 translate
$narrow setlinewidth
0 0 moveto
0 $height lineto stroke
$narrow_half 0 translate

__END__
}

sub narrow_space{
	print <<__END__;
	% narrow space
$narrow 0 translate

__END__
}

sub wide_line{
	print <<__END__;
	% wide line
$wide_half 0 translate
$wide setlinewidth 
0 0 moveto 
0 $height lineto stroke
$wide_half 0 translate

__END__
}

sub wide_space{
	print <<__END__;
	% wide space
$wide 0 translate

__END__
}

sub top{
	print <<__END__;
%!PS-Adobe-2.0 EPSF-2.0
%%BoundingBox: 0 0 500 800
%%Creator: codabar.pl-1.0 by Yoshio Murase


/Times-Roman findfont
20 scalefont
setfont

newpath gsave 0 0 translate
40 40 moveto
(CODABAR sample printed by codabar.pl \(Yoshio Murase\)) show

	% start point of barcode in the paper
40 720 translate
${scale} ${scale} scale
save

__END__
}

sub bottom{
	print <<__END__;
${showpage}
restore grestore

__END__
}

sub next{
	print <<__END__;
restore
0 ${height_margin} neg translate
save
__END__
}
